VERSION 5.00
Begin VB.Form DMXCTestMain 
   Caption         =   "DMXC Schnittstellen Test"
   ClientHeight    =   7404
   ClientLeft      =   48
   ClientTop       =   432
   ClientWidth     =   3732
   Icon            =   "DMXCTestMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   7404
   ScaleWidth      =   3732
   StartUpPosition =   3  'Windows-Standard
   Begin VB.CommandButton dmxc_commands 
      Caption         =   "Commands"
      Height          =   372
      Left            =   240
      TabIndex        =   11
      Top             =   4800
      Width           =   3252
   End
   Begin VB.CommandButton dmxc_effects 
      Caption         =   "Effects"
      Enabled         =   0   'False
      Height          =   372
      Left            =   240
      TabIndex        =   10
      Top             =   4200
      Width           =   3252
   End
   Begin VB.CommandButton dmxc_scenes 
      Caption         =   "Scenes"
      Enabled         =   0   'False
      Height          =   372
      Left            =   240
      TabIndex        =   9
      Top             =   3600
      Width           =   3252
   End
   Begin VB.CommandButton dmxc_others 
      Caption         =   "Other"
      Height          =   372
      Left            =   240
      TabIndex        =   8
      Top             =   6000
      Width           =   3252
   End
   Begin VB.CommandButton dmxc_control 
      Caption         =   "Controls (Midi In, DMX In, ...)"
      Enabled         =   0   'False
      Height          =   372
      Left            =   240
      TabIndex        =   7
      Top             =   5400
      Width           =   3252
   End
   Begin VB.CommandButton dmxc_storage 
      Caption         =   "Storage"
      Enabled         =   0   'False
      Height          =   372
      Left            =   240
      TabIndex        =   6
      Top             =   3000
      Width           =   3252
   End
   Begin VB.CommandButton dmxc_mixerchannel 
      Caption         =   "MixerChannel"
      Height          =   372
      Left            =   240
      TabIndex        =   5
      Top             =   2400
      Width           =   3252
   End
   Begin VB.CommandButton dmxc_project 
      Caption         =   "Project"
      Height          =   372
      Left            =   240
      TabIndex        =   4
      Top             =   1800
      Width           =   3252
   End
   Begin VB.CommandButton dmxc_messages 
      Caption         =   "Messages"
      Height          =   372
      Left            =   240
      TabIndex        =   3
      Top             =   1200
      Width           =   3252
   End
   Begin VB.CommandButton dmxc_exit 
      Caption         =   "Exit"
      Height          =   372
      Left            =   240
      TabIndex        =   2
      Top             =   6840
      Width           =   3252
   End
   Begin VB.CommandButton dmxc_devices 
      Caption         =   "Devices"
      Height          =   372
      Left            =   240
      TabIndex        =   1
      Top             =   600
      Width           =   3252
   End
   Begin VB.Line Line1 
      X1              =   240
      X2              =   3480
      Y1              =   6600
      Y2              =   6600
   End
   Begin VB.Label titel 
      Alignment       =   2  'Zentriert
      Caption         =   "DMXC Plugin Interface Test"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   372
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   3732
   End
End
Attribute VB_Name = "DMXCTestMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Implements IDMXCTool
Implements IExternalWindow

Private WithEvents Storage As IDataStorage
Attribute Storage.VB_VarHelpID = -1


Private Sub dmxc_commands_Click()

' Zeigt empfangene Kommandos an
  
  DMXCTestCommands.Show
  
End Sub

Private Sub dmxc_messages_Click()

' Informationen zu den von DMXControl gesendeten internen Messages

  DMXCTestMessages.Show

End Sub


Private Sub dmxc_mixerchannel_Click()

' Test des Channelmixers von DMXControl
' d.h. DMX-Werte auslesen und setzen

  DMXCTestMixer.Show

End Sub


Private Sub dmxc_others_Click()

' hier sind diverse Programmteile untergebracht, die nicht
' in die anderen Kategorien passen, z.B. ein Testprogramm
' zur Erzeugung von Dauerlast auf der Schnittstelle

  DMXCTestOthers.Show

End Sub

Private Sub dmxc_project_Click()

' Informationen zum aktuellen Projekt

  DMXCTestProject.projectname = mHelper.Project.Name
  DMXCTestProject.FileName = mHelper.Project.BaseFilename

  DMXCTestProject.Show

End Sub



Private Function IDMXCTool_AskToSaveProjectData() As Boolean
' Debug.Print "[frmDemo] IDMXCTool_AskToSaveProjectData()"
  MsgBox ("IDMXCTool_AskToSaveProjectData()")
  IDMXCTool_AskToSaveProjectData = False
' IDMXCTool_AskToSaveProjectData = True
End Function


Private Sub IDMXCTool_ClearProjectData()
' Debug.Print "[frmDemo] IDMXCTool_ClearProjectData()"
  MsgBox ("IDMXCTool_ClearProjectData()")
End Sub


Public Sub IDMXCTool_LoadProjectData()
' Debug.Print "[frmDemo] IDMXCTool_LoadProjectData()"
  MsgBox ("IDMXCTool_LoadProjectData()")
End Sub


Public Sub IDMXCTool_SaveProjectData()
' Debug.Print "[frmDemo] IDMXCTool_SaveProjectData()"
  MsgBox ("IDMXCTool_SaveProjectData()")
End Sub


Private Property Let IDMXCTool_ViewMode(ByVal RHS As DMXCTypeLib.View)
' Debug.Print "[frmDemo] IDMXCTool_ViewMode"
  MsgBox ("ViewMode =" & RHS)
  myViewMode = RHS
End Property


Private Sub dmxc_devices_Click()

' Informationen zu den Gerten des Projekts

 DMXCDevices.Show

End Sub


Private Sub dmxc_exit_Click()

 Me.Hide

End Sub


Private Function IExternalWindow_hideWindow() As Boolean
 DMXCTestMain.Hide
End Function


Private Property Get IExternalWindow_isOpen() As Boolean
 
 Dim Frm As Form

 For Each Frm In Forms
  If StrComp(Frm.Name, DMXCTestMain.Name, vbTextCompare) = 0 Then
   IExternalWindow_isOpen = True
   Exit For
  End If
 Next

End Property


Private Function IExternalWindow_loadWindow() As Boolean
 
 Dim Frm As Form

 For Each Frm In Forms
  If StrComp(Frm.Name, DMXCTestMain.Name, vbTextCompare) = 0 Then
   Exit Function
  End If
 Next
 Load DMXCTestMain

End Function

Private Function IExternalWindow_showWindow() As Boolean
 
 Dim Frm As Form

 For Each Frm In Forms
  If StrComp(Frm.Name, DMXCTestMain.Name, vbTextCompare) = 0 Then
   DMXCTestMain.Show
  End If
 Next

End Function


Private Function IExternalWindow_unloadWindow() As Boolean
 
 Dim Frm As Form

 For Each Frm In Forms
  If StrComp(Frm.Name, DMXCTestMain.Name, vbTextCompare) = 0 Then
   Unload DMXCTestMain
  End If
 Next

End Function

Private Property Let IExternalWindow_WindowState(RHS As Long)
 DMXCTestMain.WindowState = RHS
End Property

Private Property Get IExternalWindow_WindowState() As Long
 IExternalWindow_WindowState = DMXCTestMain.WindowState
End Property

